from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = "/assignor_registry/assignor_registry"
method = "POST"


body ={
  "name": "Cedente",
  "document_number": "48.838.445/0001-71",
  "person_type": "legal_person",
  "email": "qidtvm@qitech.com.br",
  "annual_revenues": 1000000,
  "is_in_national_financial_system": True,
  "address": {
    "street": "Rua Maria Carolina",
    "number": "624",
    "neighborhood": "Jardim Paulistano",
    "city": "São Paulo",
    "postal_code": "01445-000",
    "uf": "SP",
    "country": "BRA"
  },
  "phone": {
    "international_dial_code": "+55",
    "area_code": "11",
    "number": "936360268"
  },
  "related_parties": [
    {
      "name": "Parte relacionada 1",
      "related_party_type": "director",
      "nationality": "BRA",
      "passport_number": "C01X00T47",
      "direct_beneficiary": True,
      "is_representative": True

    },
    {
      "name": "Parte relacionada 2",
      "document_number": "802.834.257-41",
      "related_party_type": "director",
      "nationality": "BRA",
      "direct_beneficiary": False,
      "company_country": "NZL",
      "company_registry_number": "4984037284610",
      "is_representative": False,
      "email": "jose@yopmail.com",
      "phone": {
        "international_dial_code": "+64",
        "area_code": "11",
        "number": "936360268"
      }
    }
  ],
  "accounts": [
    {
      "account_branch": "0001",
      "account_number": "7912584",
      "account_digit": "1",
      "financial_institution_code": "329",
      "account_type": "checking_account",
      "default_account": True
    },
    {
      "account_branch": "0001",
      "account_number": "8758931",
      "account_digit": "5",
      "financial_institution_code": "329",
      "account_type": "escrow_account",
      "default_account": False
    }
  ],
  "guarantors": [
    {
      "name": "Avalista PF",
      "document_number": "172.775.419-01",
      "person_type": "natural_person",
      "email": "email@avalista.com"
    },
    {
      "name": "Avalista PJ",
      "document_number": "65.679.662/0001-85",
      "person_type": "legal_person",
      "email": "email@avalista.com",
      "guarantor_representatives": [
        {
          "name": "Assinante do Avalista",
          "document_number": "244.412.084-13",
          "email": "emailrepresentante@avalista.com"
        }
      ]
    },
  ]
}

encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())

